/***********************************************************************
*
* teach uwindow.c -- Version 3.0
*
* Copyright (c)
* Apple Computer, Inc.  1986-1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the code which implements
* windows in the Teach program.
*
***********************************************************************/

#include <types.h>
#include <gsos.h>
#include <memory.h>
#include <stdfile.h>
#include <quickdraw.h>
#include <textedit.h>
#include <window.h>
#include "teach.h"

extern unsigned int 	userID, staggerCount;
extern char 			test[80];



/***********************************************************************
*
* smartGetWTitle
*
* This function returns a pointer to the window title pascal string.
* This is a little more complicated than it used to be, given that
* NewWindow2 clones the string for the window into an unlocked handle.
* GetWTitle returns a handle with the hi-bit set (to distinguish it
* from a reguler pointer).  If the hi-bit is set, then we want to
* dereference the handle to a pointer, and return that instead.
*
***********************************************************************/
char			*smartGetWTitle(wptr)
GrafPortPtr 	wptr;
{
	char	*wtitle;

	wtitle = GetWTitle(wptr);
	if ((long)wtitle & 0x80000000L) wtitle = *(char **)((long)wtitle & 0x7FFFFFFFL);
	return(wtitle);
}



/************************************************************************
*
* drawThisWindow
*
* This routine draws the contents of all the windows.
*
************************************************************************/
pascal void drawThisWindow()
{
	DrawControls(GetPort());
}



/************************************************************************
*
* doCloseTop
*
* This routine closes the topmost window.
*
************************************************************************/
void	doCloseTop()
{
	unsigned long	refCon;

	if (refCon = GetWRefCon(FrontWindow())) DisposeHandle(refCon);
		/* Get rid of the path name handle that we keep in the refcon. */
		/* Note that it is zero if the window is untitled. */
	
	CloseWindow(FrontWindow());
}



/************************************************************************
*
* PutFileIntoWindow
*
* This routine opens the specified file, reads its contents in and sets
* the text of the text edit control of the top window to that text.
*
************************************************************************/
void	putFileIntoWindow(c1hndl)
char	**c1hndl;
{
	GSString255 	*c1ptr;
	OpenRecGS		openBlock;
	RefNumRecGS 	closeBlock;
	IORecGS 		readBlock;
	Handle			theHndl;
	unsigned int	temp;

	HLock(c1hndl);
	c1ptr = (GSString255 *)(*c1hndl + 2);

	openBlock.pCount = 15;				/* Open the indicated file. */
	openBlock.pathname = c1ptr;
	openBlock.requestAccess = 0;
	openBlock.resourceNumber = 0;
	openBlock.optionList = NULL;

	OpenGS(&openBlock); 				/* Error -- give it up. */
	if (_toolErr) {
		ErrorWindow(0, NULL, _toolErr);
		HUnlock(c1hndl);
		return;
	}

	closeBlock.pCount = 1;				/* Get ready to close file. */
	closeBlock.refNum = openBlock.refNum;

	theHndl = NewHandle(openBlock.eof, userID, 0, NULL);	/* Make a handle for file. */
	if (_toolErr) {
		ErrorWindow(0, NULL, _toolErr);
		CloseGS(&closeBlock);
		HUnlock(c1hndl);
		return;
	}
	HLock(theHndl);

	readBlock.pCount = 4;				/* Read the file. */
	readBlock.refNum = openBlock.refNum;
	readBlock.dataBuffer = *theHndl;
	readBlock.requestCount = openBlock.eof;
	ReadGS(&readBlock);

	if (_toolErr) { 					/* Error -- give it up. */
		ErrorWindow(0, NULL, _toolErr);
		CloseGS(&closeBlock);
		DisposeHandle(theHndl);
		HUnlock(c1hndl);
		return;
	}

	CloseGS(&closeBlock);				/* Almost made it -- oh well. */
	if (_toolErr) {
		ErrorWindow(0, NULL, _toolErr);
		DisposeHandle(theHndl);
		HUnlock(c1hndl);
		return;
	}

	TESetText(
		teDataIsTextBlock+refIsHandle*8,					/* Text Descriptor */
		theHndl,											/* Text Ref */
		0L, 												/* Text Length */
		0,													/* Style Descriptor */
		NULL,												/* Style Ref */
		GetCtlHandleFromID(FrontWindow(),MainWindowID)		/* Control Handle */
	);

	DisposeHandle(theHndl);
	HUnlock(c1hndl);
}



/************************************************************************
*
* putWindowIntoFile
*
* This routine opens the specified file, writes the window contents.
*
************************************************************************/
void	putWindowIntoFile(c1hndl)
char	**c1hndl;
{
	GSString255 	*c1ptr;
	NameRecGS		destroyBlock;
	CreateRecGS 	createBlock;
	OpenRecGS		openBlock;
	RefNumRecGS 	closeBlock;
	IORecGS 		writeBlock;
	Handle			theHndl;
	unsigned int	temp, err;
	unsigned long	totalSize;

	HLock(c1hndl);
	c1ptr = (GSString255 *)(*c1hndl + 2);

	destroyBlock.pCount = 1;
	destroyBlock.pathname = c1ptr;
	DestroyGS(&destroyBlock);			/* May or may not be there. */
	if ((_toolErr) && (_toolErr != fileNotFound)) {
		ErrorWindow(0, NULL, _toolErr);
		HUnlock(c1hndl);
		return;
	}

	createBlock.pCount = 4; 			/* Now it isn't there for sure. */
	createBlock.pathname = c1ptr;
	createBlock.access = 0xC3;
	createBlock.fileType = 0x04;
	createBlock.auxType = 0;
	CreateGS(&createBlock);
	if (_toolErr) {
		ErrorWindow(0, NULL, _toolErr);
		HUnlock(c1hndl);
		return;
	}

	openBlock.pCount = 15;
	openBlock.pathname = c1ptr;
	openBlock.requestAccess = 0;
	openBlock.resourceNumber = 0;
	openBlock.optionList = NULL;
	OpenGS(&openBlock);
	if (err = _toolErr) {
		DestroyGS(&destroyBlock);
		ErrorWindow(0, NULL, err);
		HUnlock(c1hndl);
		return;
	}

	closeBlock.pCount = 1;
	closeBlock.refNum = openBlock.refNum;

	theHndl = NewHandle(1L, userID, 0, NULL);
	if (!_toolErr) {
		totalSize = TEGetText(
			teDataIsTextBlock+refIsHandle*8,					/* Text Descriptor */
			theHndl,											/* Text Ref */
			0L, 												/* Text Length */
			0,													/* Style Descriptor */
			0L, 												/* Style Ref */
			GetCtlHandleFromID(FrontWindow(), MainWindowID) 	/* Control Handle */
		);
	}
	else theHndl = NULL;
	if (err = _toolErr) {
		if (theHndl) DisposeHandle(theHndl);
		CloseGS(&closeBlock);
		DestroyGS(&destroyBlock);
		ErrorWindow(0, NULL, err);
		HUnlock(c1hndl);
		return;
	}

	HLock(theHndl);
	writeBlock.pCount = 4;
	writeBlock.refNum = openBlock.refNum;
	writeBlock.dataBuffer = *theHndl;
	writeBlock.requestCount = totalSize;
	WriteGS(&writeBlock);
	err = _toolErr;
	DisposeHandle(theHndl);
	if (err) {
		CloseGS(&closeBlock);
		DestroyGS(&destroyBlock);
		ErrorWindow(0, NULL, err);
		HUnlock(c1hndl);
		return;
	}

	CloseGS(&closeBlock);
	if (err = _toolErr) {
		DestroyGS(&destroyBlock);
		ErrorWindow(0, NULL, err);
	}

	HUnlock(c1hndl);
}



/************************************************************************
*
* placeAndShowWindow
*
* This routine moves the specified window based on stagger count
* and shows it.
*
************************************************************************/
void			placeAndShowWindow(theWindow)
GrafPortPtr 	theWindow;
{
	MoveWindow(8 + 8 * staggerCount, 28 + 8 * staggerCount, theWindow);
	staggerCount++;
	staggerCount &= 0x07;
	ShowWindow(theWindow);
	SelectWindow(theWindow);
}


	
/******************************************************************************
*
* doOpenWindow
*
* This routine either asks the user what file to open and opens it.
*
******************************************************************************/
void	doOpenWindow()
{
	SFReplyRec2 	myReply;
	GrafPortPtr 	wptr;
	char			*pstr;

	SFAllCaps(1);

	myReply.nameRefDesc = refIsNewHandle;
	myReply.pathRefDesc = refIsNewHandle;
	SFGetFile2(
		10, 35,
		refIsPointer,
		"\pPick a file, any file.",
		NULL,			/* filter proc */
		NULL,			/* type list   */
		&myReply
	);

	if (myReply.good) {
		pstr = *(char **)myReply.nameRef;		/* Convert C1Output string to pascal string. */
		pstr[3] = pstr[2];
		pstr += 3;

		HLock(myReply.nameRef);

		wptr = NewWindow2(
			pstr,										/* Title reference */
			myReply.pathRef,							/* Ref con */
			drawThisWindow, 							/* Draw routine */
			NULL,										/* DefProc pointer */
			refIsResource,								/* Param Table Descriptor */
			MainWindowID,								/* Param Table Reference */
			rWindParam1 								/* Param Table Type */
		);

		DisposeHandle(myReply.nameRef);

		placeAndShowWindow(wptr);
		putFileIntoWindow(myReply.pathRef);
	}
}



/******************************************************************************
*
* doSaveAs
*
* This routine either saves the file  in the place indicated by the user.
*
******************************************************************************/
void	doSaveAs()
{
	SFReplyRec2 	myReply;
	char			*wtitle, *pstr, *wtptr, **wthndl;
	unsigned int	wtlen;
	unsigned long	refCon;

	SFAllCaps(1);

	myReply.nameRefDesc = refIsNewHandle;
	myReply.pathRefDesc = refIsNewHandle;

	wtitle = smartGetWTitle(FrontWindow()); 		/* Window title -- pascal string. */
	wtlen = *wtitle;								/* Length of title. */

	wtptr = *(wthndl = (char **)NewHandle((long)(wtlen + 2), userID, 0, NULL));
		/* Handle large enough for C1Input string version of window title. */

	wtitle = smartGetWTitle(FrontWindow());
		/* If the title was cloned by NewWindow2 call into a handle, then this handle
		** may have moved due to the NewHandle above.  Dereference it again. */

	BlockMove(wtitle + 1, wtptr + 2, (long)wtlen);	/* Move characters into handle. */
	*(int *)wtptr = wtlen;							/* Set word length for C1Input string. */
	HLock(wthndl);									/* Make it safe. */

	SFPutFile2(
		180, 35,
		refIsPointer,
		"\pGive it a name, any name.",
		refIsPointer,
		wtptr,
		&myReply
	);
	DisposeHandle(wthndl);

	if (myReply.good) {
		if (refCon = GetWRefCon(FrontWindow())) DisposeHandle(refCon);
			/* Get rid of old refCon handle. */

		SetWRefCon(myReply.pathRef, FrontWindow());
			/* Set the refCon to the new handle. */

		pstr = *(char **)myReply.nameRef;	/* Convert C1Output string to pascal string. */
		pstr[3] = pstr[2];
		pstr += 3;
		SetWTitle(pstr, FrontWindow()); 	/* Set the window title to new name. */
		DisposeHandle(myReply.nameRef);

		putWindowIntoFile(myReply.pathRef);
	}
}



/******************************************************************************
*
* doSave
*
* This routine either saves the file (unless it is new then it does a save
* as).
*
******************************************************************************/
void	doSave()
{
	GrafPortPtr 	wptr;
	unsigned long	refCon;

	refCon = GetWRefCon(wptr = FrontWindow());

	if (!refCon) doSaveAs();
	else {
		putWindowIntoFile(refCon);
	}
}



/******************************************************************************
*
* NewWindow
*
* This routine opens a new untitled window.
*
******************************************************************************/
void	doNewWindow()
{
	GrafPortPtr 	wptr;

	wptr = NewWindow2(
		"\pUntitled",			/* Title reference*/
		NULL,					/* Ref con */
		drawThisWindow, 		/* Draw routine */
		NULL,					/* DefProc pointer */
		refIsResource,			/* Param Table Descriptor */
		MainWindowID,			/* Param Table Reference */
		rWindParam1 			/* Param Table Type */
	);
		
	placeAndShowWindow(wptr);
}



/*******************************************************************************
*
* SetUpWindows
*
* Sets up WindowList record for use through out the program.
*
*******************************************************************************/
void	setupWindows()
{
	doNewWindow();
}
